within ;
model IdealFinalDriveTestBench

  Modelica.Mechanics.Rotational.Sources.Torque torque
    annotation (Placement(transformation(extent={{-48,16},{-28,36}})));
  FinalDrive finalDrive(ratio=3.1)
    annotation (Placement(transformation(extent={{-6,14},{14,34}})));
  Modelica.Blocks.Sources.Ramp ramp(height=100, duration=20)
    annotation (Placement(transformation(extent={{-92,18},{-72,38}})));
  Modelica.Mechanics.Rotational.Components.Damper damper(d=0.7)
    annotation (Placement(transformation(extent={{40,12},{60,32}})));
  Modelica.Mechanics.Rotational.Components.Damper damper1(d=0.5)
    annotation (Placement(transformation(extent={{30,-12},{50,8}})));
  Modelica.Mechanics.Rotational.Components.Fixed fixed
    annotation (Placement(transformation(extent={{50,-38},{70,-18}})));
equation
  connect(ramp.y, torque.tau) annotation (Line(
      points={{-71,28},{-60,28},{-60,26},{-50,26}},
      color={0,0,127},
      smooth=Smooth.None));
  connect(torque.flange, finalDrive.flange_a) annotation (Line(
      points={{-28,26},{-16,26},{-16,24},{-5,24}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(damper.flange_b, fixed.flange) annotation (Line(
      points={{60,22},{60,-28}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(damper1.flange_b, fixed.flange) annotation (Line(
      points={{50,-2},{56,-2},{56,-28},{60,-28}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(finalDrive.flange_b_left, damper.flange_a) annotation (Line(
      points={{12,29.8},{27,29.8},{27,22},{40,22}},
      color={0,0,0},
      smooth=Smooth.None));
  connect(finalDrive.flange_b_right, damper1.flange_a) annotation (Line(
      points={{12,18},{22,18},{22,-2},{30,-2}},
      color={0,0,0},
      smooth=Smooth.None));
  annotation (uses(Modelica(version="3.2")), Diagram(graphics));
end IdealFinalDriveTestBench;
